# create a function that calculates the derivative
dN_dt <- function(t,N,parms)
{
list(with(parms,r*N*(1-N/K)))
}

# define the model parameters and initial condition
parms=list(K=100,r=0.5)
N0 = 5

# specify time points at which to evaluate population size
dt = 1
ts = seq(0,20,dt)

# set up the vector to store the population sizes
N_t_Euler = numeric(length(ts))
N_t_Euler[1] = N0
N = N0

# apply the Euler method
for ( i in 2:length(ts) )
  {
  N = N + dN_dt(NA,N,parms)[[1]]*dt
  N_t_Euler[i] = N
  }

plot(ts,N_t_Euler,pch=19,col='blue',type='o',xlab='t',
     ylab='N') 
